<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Radial Stakeout Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis radiálního vytýčení</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis radiálního vytýčení</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Project Data -->
                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Příčná trasa:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="//StakeoutPoint/@alignment"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr />
                                <table cellpadding="2" cellspacing="2" class="margin" width="70%">
                                    <tbody>
                                        <xsl:for-each select="HorizontalAlignment[StakeoutPoints/StakeoutPoint]">
                                            <tr>
                                                <th align="right" colspan="2" lang="en">Trasa osy:&#xa0;</th>
                                                <td align="left" colspan="3"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en">BZ</th>
                                                <th class="underline" lang="en">BO</th>
                                                <th class="underline" lang="en">BV</th>
                                                <th class="underline" lang="en">Úhel vpravo</th>
                                                <th class="underline" lang="en">Vzdálenost</th>
                                            </tr>
                                            <xsl:for-each select="StakeoutPoints/StakeoutPoint">
                                                <tr>
                                                    <td class="sidepad" align="right"><xsl:value-of select="backsightPoint/@name"/></td>
                                                    <td class="sidepad" align="right"><xsl:value-of select="occupiedPoint/@name"/></td>
                                                    <td class="sidepad" align="right"><xsl:value-of select="foresightPoint/point/@name"/></td>
                                                    <td class="sidepad" align="right"><xsl:value-of select="cif:angularFormat(number(@rightAngle))"/></td>
                                                    <td class="sidepad" align="right"><xsl:value-of select="cif:distanceFormat(number(@distance))"/></td>
                                                </tr>
                                            </xsl:for-each>
                                        </xsl:for-each>
                                        <xsl:for-each select="CogoPoints[StakeoutPoints]">
                                            <tr>
                                                <th align="left" colspan="2" lang="en">Cogo body:&#xa0;</th>
                                            </tr>
                                            <tr>
                                                <th class="underline" lang="en">BZ</th>
                                                <th class="underline" lang="en">BO</th>
                                                <th class="underline" lang="en">BV</th>
                                                <th class="underline" lang="en">Úhel vpravo</th>
                                                <th class="underline" lang="en">Vzdálenost</th>
                                            </tr>
                                            <xsl:for-each select="StakeoutPoints/StakeoutPoint">
                                                <tr>
                                                    <td class="sidepad" align="right"><xsl:value-of select="backsightPoint/@name"/></td>
                                                    <td class="sidepad" align="right"><xsl:value-of select="occupiedPoint/@name"/></td>
                                                    <td class="sidepad" align="right"><xsl:value-of select="foresightPoint/point/@name"/></td>
                                                    <td class="sidepad" align="right"><xsl:value-of select="cif:angularFormat(number(@rightAngle))"/></td>
                                                    <td class="sidepad" align="right"><xsl:value-of select="cif:distanceFormat(number(@distance))"/></td>
                                                </tr>
                                            </xsl:for-each>
                                        </xsl:for-each>
                                    </tbody>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vytvořit body vytýčení pomocí <em>Nástroje &gt; XML Výpisy &gt; Vytýčení</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte vybrat buď směrové řešení nebo zpětný (BZ) a dopředný bod (BV) v záložce 
                <em>Obecně</em> ve skupině <em>Z</em>.<br/><br style="line-height:50%"/>
                <strong>Poznámka:&#xa0;</strong> Zpětný a dopředný bod jsou potřebné pro kompletní výpis.
            </p>
            <p class="normal1" lang="en">
                Musíte zapnout nejméně jednu volbu ve skupině <em>Zahrnout směrové body</em> nebo 
                zadat hodnotu <em>Interval</em> v záložce <em>Obecně</em>.
            </p>
            <p class="normal1" lang="en">
                Musíte také vybrat nejméně jedno směrové řešení v záložce <em>Směrová řešení</em> 
				nebo jeden cogo bod v záložce <em>Cogo body</em> nebo jeden prvek v záložce <em>Prvky</em>.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2006 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
